clear
clc
load('hemisphere_dataset_summary.mat')

dprimes_all = [];
traditional_ind = [1, 2, 35, 37, 42, 43, 45, 46, 51:66];


for i=1:6
    for j=1:3
        if isempty(choices_all{i,j})
            continue
        end
        choices = choices_all{i,j};
        
        metrics = metrics_all{j};
        features = metrics';
        infs = isinf(features);
        features(infs) = 0;
        features = zscore(features, 0, 1);
        features(infs) = 0;

        ind = find(choices == 1);
        feature_true = features(ind,:);
        ind = find(choices == -1);
        feature_false = features(ind,:);


        means_true = mean(feature_true,1);
        means_false = mean(feature_false,1);
        stds = sqrt(std(feature_true,1).^2 + std(feature_false,1).^2) ./ sqrt(2);
        dprimes = abs((means_true - means_false ) ./ stds);
        
        if isempty(dprimes_all)
            dprimes_all = dprimes;
        else
            dprimes_all = [dprimes_all;dprimes];
        end
    end
end

figure
color_order = get(gca, 'ColorOrder');
for i=1:size(dprimes_all,2)
    x = zeros(1,size(dprimes_all,1))+i;
    y = dprimes_all(:,i);
    if i < 37
        col = color_order(1,:);
    elseif i< 47
        col = color_order(2,:);
    else
        col = color_order(4,:);
    end

        symbol = 'o';
        scatter(x,y,5,col,'filled',symbol)
        hold on
end
hold on
boxplot(dprimes_all, 'symbol', '')
hold on
set_common_gca_props
pbaspect([7,2.5,1])
exportgraphics(gcf,'Fig3B.eps','ContentType','vector')

function set_common_gca_props
ax = gca;
ax.Color = 'none';
ax.LineWidth = 1.5;
ax.TickLength = [0.03, 0.03];
end
